from selenium import webdriver
from selenium.webdriver.chrome.options import Options
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.common.exceptions import TimeoutException, NoSuchElementException, StaleElementReferenceException
from webdriver_manager.chrome import ChromeDriverManager
import pandas as pd
import time

options = Options()
options.headless = False
options.add_argument("--incognito")

service = Service(ChromeDriverManager().install())
driver = webdriver.Chrome(service=service, options=options)
wait = WebDriverWait(driver, 15)

hasil_data = []

for nomor_id in range(1, 290):
    kode_id = f"{nomor_id:05d}"
    full_id = f"69944965-12-2-{kode_id}"
    url = f"https://spmb.jabarprov.go.id/detail/hasil-seleksi/{full_id}"
    print(f"Mengambil data dari ID {kode_id} ...")
    driver.get(url)

    # Jeda waktu setelah buka halaman, supaya load sempurna
    time.sleep(3)

    try:
        wait.until(EC.presence_of_element_located((By.XPATH, '//*[@id="__next"]/div[4]/div/div/div[2]/div/table')))
        rows = driver.find_elements(By.XPATH, '//*[@id="__next"]/div[4]/div/div/div[2]/div/table/tbody/tr')

        if not rows:
            print("  Tidak ada baris data siswa, dilewati.")
            # Jeda sebelum ke siswa berikutnya
            time.sleep(3)
            continue

        for row in rows:
            try:
                cols = row.find_elements(By.TAG_NAME, "td")
                if len(cols) < 7:
                    print("  Data siswa tidak lengkap, dilewati.")
                    continue

                nomor = cols[0].text.strip()
                nomor_pendaftar = cols[1].text.strip()
                nama_siswa = cols[2].text.strip()
                asal_sekolah = cols[3].text.strip()

                lokasi = cols[4].find_elements(By.TAG_NAME, "li")
                kabupaten = lokasi[0].text if len(lokasi) > 0 else ""
                kecamatan = lokasi[1].text if len(lokasi) > 1 else ""
                desa = lokasi[2].text if len(lokasi) > 2 else ""

                score = cols[5].text.strip()

                main_tab = driver.current_window_handle
                existing_tabs = driver.window_handles

                try:
                    button = cols[6].find_element(By.TAG_NAME, "button")
                    button.click()

                    # Jeda tunggu tab baru load agar bukan about:blank
                    time.sleep(4)

                    new_tabs = driver.window_handles
                    new_tab = [t for t in new_tabs if t not in existing_tabs]

                    if new_tab:
                        driver.switch_to.window(new_tab[0])
                        try:
                            status_elem = wait.until(
                                EC.presence_of_element_located((By.XPATH, '/html/body/div/div[2]/div[4]/div/div[2]/div/p'))
                            )
                            status = status_elem.text.strip()
                        except TimeoutException:
                            status = "Status tidak ditemukan"
                        driver.close()
                        driver.switch_to.window(main_tab)
                    else:
                        status = "Tab tidak terbuka"
                except Exception:
                    status = "Tombol tidak dapat diklik"

                hasil_data.append({
                    "ID Halaman": full_id,
                    "Nomor": nomor,
                    "Nomor Pendaftar": nomor_pendaftar,
                    "Nama": nama_siswa,
                    "Asal Sekolah": asal_sekolah,
                    "Kabupaten": kabupaten,
                    "Kecamatan": kecamatan,
                    "Desa": desa,
                    "Skor": score,
                    "Status": status
                })

                print(f"  Data siswa: {nama_siswa} | Status: {status}")

                # Jeda kecil tiap siswa supaya aman
                time.sleep(1)

            except (NoSuchElementException, StaleElementReferenceException) as e:
                print(f"  Gagal ambil data baris: {e}")

    except TimeoutException:
        print("  Halaman tidak memuat data siswa.")

    # Jeda sebelum ke siswa berikutnya
    time.sleep(3)

driver.quit()

# Buat DataFrame dan urutkan data yang belum diterima di atas
df = pd.DataFrame(hasil_data)

# Urutkan dengan status "Maaf, Anda Belum Diterima" di atas
df['Status_sort'] = df['Status'].apply(lambda x: 0 if 'Maaf, Anda Belum Diterima' in x else 1)
df = df.sort_values(by=['Status_sort']).drop(columns=['Status_sort'])

# Simpan ke Excel dengan warna merah untuk yang belum diterima
from openpyxl import load_workbook
from openpyxl.styles import Font, PatternFill

excel_path = "data_siswa_spmb.xlsx"
df.to_excel(excel_path, index=False)

# Buka file Excel dan warnai baris status "Maaf, Anda Belum Diterima"
wb = load_workbook(excel_path)
ws = wb.active

red_fill = PatternFill(start_color="FFFF0000", end_color="FFFF0000", fill_type="solid")
white_font = Font(color="FFFFFFFF")

# Cari kolom "Status"
header = [cell.value for cell in ws[1]]
status_col_idx = header.index("Status") + 1  # 1-based indexing di openpyxl

for row in range(2, ws.max_row + 1):
    cell = ws.cell(row=row, column=status_col_idx)
    if "Maaf, Anda Belum Diterima" in str(cell.value):
        for col in range(1, ws.max_column + 1):
            ws.cell(row=row, column=col).fill = red_fill
            ws.cell(row=row, column=col).font = white_font

wb.save(excel_path)

print("\nData selesai diambil dan disimpan di 'data_siswa_spmb.xlsx' dengan 'Belum Diterima' di atas dan berwarna merah.")